libname q 'c:/SASCodeforBook/SASDataSets';
data tryone; set q.humandevelopment; 

	/*This syntax makes the standard HDIRank Runs Replicating the Chapter's Tables*/

	/*These runs weight the country by the square root of its population*/

Sqrtpop = sqrt(populat);

	/*this code makes the corruption typology*/
coruptyp = .;
	if 1 le corrupt < 3 then coruptyp = 4;
	if 3 le corrupt le 3.3 then coruptyp = 3;
	if 3.4 le corrupt le 5 then coruptyp = 2;
	if 5.01 le corrupt le 11 then coruptyp = 1;

	/*this code makes the freedom typology*/
Fretyp99 = . ;
	if free399 = 'F' then fretyp99 = 1;
	if free399 = 'P' or free399 = 'PF' then fretyp99 = 2;
	if free399 = 'NF' then fretyp99 = 3; 

	/*The following code can be ignored, it presents my method of simulating the effect of class statement
	on missing data.  s stands for signal. This code will produce a flat file of 138 countries*/
sregion = .;
	if region = '01e' or region = '01m' or region = '01n' or region = '01s' or 
	region = '01w' then sregion = 1;
	if region = '02' then sregion = 1;
	if region = '03c' or region = '03ca' or region = '03sa' or region = '04e' or
	region = '04sc' or region = '04se' or region = '04w' then sregion = 1;
	if region = '05e' or region = '05n' or region = '05s' or region = '05w' then sregion = 1;
	if region = '06' then sregion = 1; 

sculture = .;
	if culture = 'african' or culture = 'buddhist' or culture = 'hindu' or culture = 'islamic'
	or culture = 'japan' or culture = 'latin' or culture = 'orthodox' or culture = 'sinic' or
	culture = 'western' then sculture = 1;

sfretyp9 = .;
	if fretyp99 ne . then sfretyp9 = 1;

sdebt = .;
	if debt ne . then sdebt = 1;

sconflic = .;
	if conflict ne . then sconflic = 1;

scorupt = .;
	if coruptyp ne . then scorupt = 1;
    
sslave = .;
	if slave98 ne . then sslave = 1;
 
fulslave = .;
	if (slavery  ne . or slavery ne 0) then fulslave = 1;

shdirank = .;
	if hdirank ne . then shdirank = 1;

		/*signal=1 will eliminate countries that have some missing data*/

signal = scorupt * sconflic * sdebt * sfretyp9 * sculture * sregion *sslave * shdirank;
run;

	   /* This code creates the working dataset explore that has 138 cases.  The revhdi
	variable reverses the ranking of the human development scale so that higher scores indicate
	poorer human development*/

data explore; set tryone;
	if signal = 1;  *there will be 138 cases;
	revhdi = 183-hdirank;

	/* This code dichotomizes the cultures as similar to the west (LikeWest = 1) or not (0)*/

LikeWest = .;
	if culture = 'african' or culture = 'buddhist' or culture = 'hindu' or culture = 'islamic'
	then LikeWest = 0;
	If culture = 'japan' or culture = 'latin' or culture = 'orthodox' or culture = 'sinic' or
	culture = 'western' then likewest = 1;

		*These codes dichotomize the instrumental freedom prerequisites;
lodebt = 1;
	if debt = 2 then lodebt = 0;
	if debt = . then lodebt = .;

dichofre = 0;
	if fretyp99 = 1 then dichofre = 1;
	if fretyp99 = . then dichofre = .;

integrit = 0;
	if coruptyp = 1 then integrit =1;
	if coruptyp = . then integrit = .;

emancip = . ;
	if slavery = 3 or slavery = 4 then emancip = 0;
	if slavery = 1 or slavery = 2 then emancip = 1;

nochaos = 1;
	if conflict = . then nochaos = .;
	if conflict > 0 then nochaos = 0;

	/* This code creates a summary index of instrumental freedoms*/

instfree = dichofre + integrit + emancip +lodebt + nochaos;

run;

data explore; set explore;

	/* Code for Table 7.2, Descriptive Models of Human Development Rank*/
	/* s is an appreviation for solution*/
	/* These runs do not use the parms/nobound statement. If implemented it requests a likelihood
	ratio test for the variance components and changes the bounds on their confidence limits*/
	/* Figures 7.2 and 7.3 depict some of these estimates*/

Title '7.2 Model 1, Mixed Weighted no nesting,  HDIRank, Intercepts Only';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 Debt conflict coruptyp;
	model hdirank =  /solution ;
	random region/solution; 
	weight sqrtpop;
	*parms/nobound;  
	*Figure 7.2 depicts random effects estimates;
run;

Title '7.2 Model 2, Mixed weighted no nesting,  HDIRank, Full Descriptive Model';
proc mixed covtest ratio cl=wald;
	class  region culture slave98 fretyp99 Debt conflict coruptyp;
	model hdirank = culture slave98 fretyp99 debt conflict corrupt /s ;
	random region/solution;
	lsmeans culture / pdiff adjustment = bon cl;
	weight sqrtpop;
	*parms/nobound;
	*Figure 7.2 depicts random effects estimates;
	*Figure 7.3 depicts the least-square means for culture; 
run;

Title '7.2 Model 3, Mixed weighted no nesting,  HDIRank, no Civilizations (no culture)';
proc mixed covtest ratio  cl=wald ;
	class  region slave98 fretyp99 debt conflict coruptyp;
	model hdirank =  slave98 fretyp99 debt conflict corrupt /s ;
	random region/solution;
	weight sqrtpop;
	*parms/nobound; 
	* Figure 7.2 depicts random effects estimates; 
run;

Title ' 7.2 Model 4, Mixed weighted no nesting,  HDIRank, no Slavery (no slave98)';
proc mixed covtest ratio  cl=wald ;
	class  region culture fretyp99 debt conflict coruptyp;
	model hdirank = culture fretyp99 debt conflict corrupt /s ;
	random region/solution;
	weight sqrtpop;
	*parms/nobound;  
run;

Title ' 7.2 Model 5, Mixed weighted no nesting,  HDIRank, no Freedom (no fretyp99)';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 debt conflict coruptyp;
	model hdirank = culture slave98 debt conflict corrupt /s ;
	random region/solution;
	weight sqrtpop;
	*parms/nobound;  
run;

Title ' 7.2 Model 6, Mixed weighted no nesting, HDIRank, No HIPC, no Heavy Dept (no debt)';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 conflict coruptyp;
	model hdirank = culture slave98 fretyp99 conflict corrupt /s ;
	random region/solution;
	weight sqrtpop;
	*parms/nobound;  
run;

Title '7.2 Model 7, Mixed weighted no nesting, HDIRank, no Conflict (no conflict)';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 debt coruptyp;
	model hdirank = culture slave98 fretyp99 debt corrupt /s ;
	random region/solution;
	weight sqrtpop;
	*parms/nobound;  
run;

Title '7.2 Model 8, Mixed weighted no nesting,  HDIRank, no corruption (no coruptyp)';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 fretyp99 debt conflict;
	model hdirank = culture slave98 fretyp99 debt conflict/s ;
	random region/solution;
	weight sqrtpop;
	*parms/nobound;  
run;

	/*Footnotes to Table 7.2, dichotomized freedom and slavery, respectively*/

Title '7.2 Model 2a, first table footnote a Mixed weighted no nesting, HDIRank, Full Model,
	freedom dichotomized=dichofre)';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 dichofre debt conflict coruptyp;
	model hdirank = culture slave98 dichofre debt conflict corrupt /s ;
	random region/solution;
	weight sqrtpop;
	*parms/nobound;  
run;

Title '7.2 Model 6a, second table footnote a, Mixed weighted no nesting, HDIRank, Full Model, 
	freedom dichotomized=dichofre), no debt';
proc mixed covtest ratio  cl=wald ;
	class  region culture slave98 dichofre conflict coruptyp;
	model hdirank = culture slave98 dichofre conflict corrupt /s ;
	random region/solution;
	weight sqrtpop;
	*parms/nobound;  
run;

Title ' 7.2 Model 7a, table footnote b, Mixed weighted no nesting, HDIRank, Full Model,
	slavery dichotomized = emancip, no conflict';
proc mixed covtest ratio  cl=wald ;
	class  region culture emancip fretyp99 debt coruptyp;
	model hdirank = culture emancip fretyp99 debt corrupt /s ;
	random region/solution;
	weight sqrtpop;
	*parms/nobound;  
run;

  	*/ The code for Table 7.2 is now complete*/
	*/ The syntax in this file is copyright by Robert B. Smith  */






































		





































